<?php
const IS_ESSAY = 1;

function appendAuthor($data) {
    $token = 'lMcjfhOJuUBKfaSzKcMHEzXlBmfzWboKfaJuLeBa';
    $timestamp = strval(floor(microtime(true)));
    $nonce = rand(1000, 9999);
    $signature = sha1($token. $timestamp . $nonce);

    $data['token'] = $token;
    $data['timestamp'] = $timestamp;
    $data['nonce'] = $nonce;
    $data['signature'] = $signature;
    $data['source'] = 'xian';
    $data['appId'] = 'A2';

    return $data;
}


function sendJsonRequest($url, $data, $appendAuthor = true, $headers = []) {
    // 初始化cURL会话
    $ch = curl_init($url);

    if ($appendAuthor) {
        $data = appendAuthor($data);
    }

    // 将数据转换为JSON字符串
    $jsonData = json_encode($data);

    $headers = array_merge($headers, [
        'Content-Type: application/json',              // 设置Content-Type为JSON
        'Content-Length: ' . strlen($jsonData)        // 设置Content-Length
    ]);

//    print_r($headers);

    // 设置cURL选项
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  // 返回响应结果而非直接输出
    curl_setopt($ch, CURLOPT_POST, true);             // 发送POST请求
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);  // 设置请求体

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);  // 禁用服务器证书验证
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    // 执行请求并获取响应
    $response = curl_exec($ch);

    // 检查是否有错误
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        // 处理错误
        echo "cURL Error: $error";
    }

    // 关闭cURL会话
    curl_close($ch);

    return $response;
}

function submitEssayAnswer($requestData) {
    $url = 'https://bdm.bjyisheng.com.cn:9901/admin/appUniApp/submitEssayAnswer';

    $data = json_decode(sendJsonRequest($url, $requestData), true);

    print_r($data);

    return $data['data']['_id'];
}

function getId($id) {
    $url = 'https://bdm.bjyisheng.com.cn:9901/admin/writingQuestion/queryYkwPaperCompositionInfos';
    $requestData = [
        'questionId' => $id,
    ];

    $response = sendJsonRequest($url, $requestData, true);
    $response = json_decode($response, true);

    if ($response && isset($response['code']) && intval($response['code']) === 0) {

        return $response['data']['id'];
    };

    return false;
}

function getResult($requestData) {
    $url = 'https://bdm.bjyisheng.com.cn:9901/admin/them/api/query_result';

    $data = json_decode(sendJsonRequest($url, $requestData), true);

    return $data;
}

function ocr($imgUrl) {
    $url = "https://bdm.bjyisheng.com.cn:3721/v1/workflows/run";

    $header = [
//        "Authorization: Bearer app-pJbCL4l1wIWT55k0pPsBkT7S",
//        "Authorization: Bearer app-M8ZSE8iU0zB8FvL4dHWj3pq5",
        "Authorization: Bearer app-gqClI9mbTTHevennbIwJvRBu",
    ];

    $data = [
        "inputs" => [
            "image" => [
                "transfer_method" => "remote_url",
                "url" => $imgUrl,
                "type" => "image",
            ]
        ],
        "response_mode" => "blocking",
        "user" => "caobohua",
    ];

    $response = sendJsonRequest($url, $data, false, $header);

    return $response;
}

function clearWith($str) {
    if (is_null($str)) {
        return NULL;
    }
    $str = preg_replace('/_{2,}/', ' ', $str);
    $str = preg_replace('/-{2,}/', ' ', $str);

    return trim($str);
}

function clearSpaceLine($strLine) {
    return preg_replace("/^\s*[\r\n]/m", "", $strLine);
}

function isImgMarkDown($str) {
    $pattern = '/^!\[(.*?)\]\((.*?)(\s+"(.*?)")?\)$/';
    return preg_match($pattern, $str, $match);
}

function addEssay($data) {
    $requestData = [
        'questionList' => [$data]
    ];

    $url = 'https://bdm.bjyisheng.com.cn:9901/admin/writingQuestion/syncYkwEssayInfos';

    $response = sendJsonRequest($url, $requestData);

    $data = json_decode($response, true);
    if ($data) {
        return $data;
    }

    return false;
}

function getWorkNum($str) {
    //词数应为40—50
    if (preg_match('/[词|字]数[ 应为:：].*?(\d+) *[-—－–~～至到] *(\d+)/u', $str, $matches)) {
        return [intval($matches[1]), intval($matches[2])]; // 返回捕获到的数字
    }

    if (preg_match('/[词|字]数(\d+) *[-—－–~～至到] *(\d+)/u', $str, $matches)) {
        return [intval($matches[1]), intval($matches[2])]; // 返回捕获到的数字
    }

    if (preg_match('/要求：(\d+)[-—－–~～至到](\d+)/u', $str, $matches)) {
        return [intval($matches[1]), intval($matches[2])]; // 返回捕获到的数字
    }

    if (preg_match('/(\d+) *[-—－–~～至到] *(\d+?)\D?[词字]+/u', $str, $matches)) {
        return [intval($matches[1]), intval($matches[2])]; // 返回捕获到的数字
    }

    if (preg_match('/[字|词]数[应约为在 :：]*?(\d+?) *?[个左以]/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/词数至少(\d+)/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/[字|词][约为在 :：]*?(\d+?) *?[个左以]/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/词数：l00左右/u', $str, $matches)) {
        return 100; // 返回捕获到的数字
    }

    if (preg_match('/词数 ?l00 ?左右/u', $str, $matches)) {
        return 100; // 返回捕获到的数字
    }

    if (preg_match('/词数应为l50左右/u', $str, $matches)) {
        return 150; // 返回捕获到的数字
    }

    if (preg_match('/词数应为 l50 左右/u', $str, $matches)) {
        return 150; // 返回捕获到的数字
    }

    if (preg_match('/(\d+)[ ]*?[词|字]左右/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/[词|字]数.*?不[能]?少于?.*?(\d+)/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/不少于 *?(\d+) *?[字|词]/u', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    if (preg_match('/(\d+?)[ 个单]*?词/', $str, $matches)) {
        return intval($matches[1]); // 返回捕获到的数字
    }

    return 78;
}

